	subroutine mvlrt(x,n,k,np,u1,u2,u3,ndf1,ndf2,pvaluee,pvaluec,
     +	pvaluef,iflag)
c
c**********************************************************************
c
c   FORTRAN subroutine to calculate the likelihood ratio statistic
c   for a test of the linearity of a time series.
c
c   Input: x = a double precision matrix of dimension n x k containing
c              the time series.
c          n = an integer containing the length of the time series
c              and the number of columns of x.
c          k = an integer containing the number of time series and
c              the number of rows of x.
c          np = an integer containing the order of the k-variate
c               autoregressive process.
c
c
c   Output: u = a double precision real scalar containing the
c               value of the likelihood ratio test statistic.
c           ndf1 = an integer containing the numerator degrees of
c                  freedom.
c           ndf2 = an integer containing the denominator degrees of
c                  freedom.
c           pvaluee = a double precision real scalar containing the 
c                     p-value of the test statistic from its exact 
c                     distribution.
c           pvaluec = a double precision real scalar containing the
c                     p-value of the test statistic from the chi-square
c                     appproximation to the exact distribution.
c           pvaluef = a double precision real scalar conatining the
c                     p-value of the test statistic from the F 
c                     approximation to the exact distribution.
c
c   Accuracy:  Implicit double precision (a-h,p-z)
c
c   Created: 7/19/97 Bonnie Ray
c   Modified: 7/27/97 Jane L. Harvill
c
c   Subprograms called: vech, IMSL subroutine DRGIVN,  IMSL subroutine
c                       DLFTSF, IMSL subroutine DLFDSF, IMSL double
c                       precision function DMACH, udists.
c
c**********************************************************************
c
	parameter (nkmx =5, nmx = 500, npmx = 10, nqmx = (npmx*nkmx)**2)
	parameter (nsmx = nqmx + npmx*nkmx)
c
	implicit double precision (a - h, p - z)
c
	double precision x(nmx,nkmx),xr(nmx,nkmx+nsmx),b(nsmx,nsmx)
	double precision sse1(nkmx,nkmx),sse2(nkmx,nkmx),ssr(nkmx,nkmx)
	double precision xt1(nkmx*npmx),xt1t(1,nkmx*npmx),y(nqmx),tempu(1)
	double precision r(nsmx,nsmx),d(nsmx),xmin(nsmx),xmax(nsmx) 
	double precision tstats(8)
c
	integer inddep(nkmx),indind(npmx*nkmx), indind2(nsmx)
c
	external vech, DRGIVN, DLFTSF, DLFDSF, DMACH
c
c   Initialize matrices and constants:
c
	ndf1 = 0
	ndf2 = 0
	u = 0.0d0
	pvaluee = 0.0d0
	pvaluec = 0.0d0
	pvaluef = 0.0d0
c
c
c  Set up data matrix for the first and second regressions in a form
c  to be used in the IMSL subroutine DRGIVN.  The "data matrix" is
c  xr = [X_t|X_{t-1},...,X_{t-p}|X^2{t-1},X_{t-1}X{t-2},...,X^2_{t-p}].
c
	iz = (np*k)*(np*k+1)/2
c
	do i = 1,n-np
		do j = 0,np
			do l = 1,k
				xr(i,k*j+l) = x(i+np-j,l)
			enddo
c
c  Form vector of additional responses for second regression (full
c  model). xt1 = p+i-j row of original data matrix (x). xt1t is the
c  transpose of xt.
c
			if(j.gt.0) then
				do l = 1,k
					xt1(k*(j-1)+l) = x(i+np-j,l)
					xt1t(1,k*(j-1)+l) = xt1(k*(j-1)+l)
				enddo
			endif
		enddo
		call vech(xt1,xt1t,npmx*nkmx,np*k,1,1,np*k,0,y)
c
		do l = 1,iz
			xr(i,k*np+k+l) = y(l)
		enddo
	enddo
c
c   Perform first regression using the "reduced model" containing
c   only linear terms and no nonlinear terms.
c
c   IMSL subroutine DRGIVN is used to perform calculations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of xr that are the independent variables.  
c   indind must be of length np*k.
c
c   inddep is a vector of indices required by DRGIVN.  inddep is of
c   length k containing the column numbers of xr that are the
c   dependent variables.
c
	do i = 1,np*k
		indind(i) = k + i
	enddo
	do i = 1,k
		inddep(i) = i
	enddo
c
	call DRGIVN(0,n-np,k+np*k+iz,xr,nmx,0,np*k,indind,k,inddep,0,0,
     +	0,100*dmach(4),b,nsmx,r,nsmx,d,irank,dfe,sse1,nkmx,nrmiss,
     +	xmin,xmax)

	if (iflag .eq. 1)  then
	  write(10,*) 'Estimated Coefficients from Linear Model'
	  do i=1,k*np
	    write(10,100) (b(i,j),j=1,k)
	  enddo
	  write(10,*) 'SSE from Linear Model'
	  do i=1,k
	    write(10,100) (sse1(i,j),j=1,k)
	  enddo
100	format(4F15.4)
      endif
c
c  Perform regression on "full model" (includes linear and all second-
c  order terms.  
c
c  Again call DRGIVN.
c
	do i = 1,np*k+iz
		indind2(i) = k + i
	enddo
c
	call DRGIVN(0,n-np,k+np*k+iz,xr,nmx,0,np*k+iz,indind2,k,inddep,
     +	0,0,0,100*dmach(4),b,nsmx,r,nsmx,d,irank,dfe,sse2,nkmx,
     +	nrmiss,xmin,xmax)

	if (iflag .eq. 1)then
	  write(10,*) 'Estimated Coefficients from Full Model'
	  do i=1,k*np+iz
	    write(10,100) (b(i,j),j=1,k)
	  enddo
	  write(10,*) 'SSE from Full Model'
	  do i=1,k
	    write(10,100) (sse2(i,j),j=1,k)
	  enddo
	  write(10,*) 'Dependent Variables'
	  do i=1,n-np
	   write(10,110) (xr(i,j), j=1,k)
	  enddo
	  write(10,*) 'Regressors for Linear Model'
	  do i=1,n-np
	   write(10,110) (xr(i,j), j=k+1,k+k*np)
	  enddo
	  write(10,*) 'Extra Regressors for Full Model'
	  do i=1,n-np
	   write(10,110) (xr(i,j), j=k+k*np+1,k+k*np+iz)
	  enddo
110	format(50F15.4) 
      endif
c
	ssr=sse1-sse2
	ndf1=iz
	ndf2=(n-np)-np*k-iz
c	ndf2=n-np*k-iz
      CALL DRHPTE(dble(ndf2),k,sse2,nkmx,0,tempu,1,dble(ndf1),
     +	ssr,nkmx,tstats)
      u1=tstats(1)
      u2=tstats(3)
	u3=tstats(4)
	pvaluee=tstats(5)
	pvaluec=tstats(7)
	pvaluef=tstats(8) 

	return
	end
